/**
 * A client-side 802.1x implementation 
 *
 * This code is released under both the GPL version 2 and BSD licenses.
 * Either license may be used.  The respective licenses are found below.
 *
 * Copyright (C) 2002 Bryan D. Payne & Nick L. Petroni Jr.
 * All Rights Reserved
 *
 * --- GPL Version 2 License ---
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * --- BSD License ---
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  - Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *  - Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  - All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *       This product includes software developed by the University of
 *       Maryland at College Park and its contributors.
 *  - Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*******************************************************************
 * File: snmp.h
 *
 * Authors: Chris.Hessing@utah.edu
 *
 *******************************************************************/

#ifndef _XSUP_SNMP_H_
#define _XSUP_SNMP_H_

#include "profile.h"

/*************************************
 *
 *  This structure contains SNMP related variables for the 802.1X supplicant
 *   as defined in section 9.5 of 802.1X-2001.
 *
 *************************************/
struct snmp_data {
  // The configuration pieces of the SNMP defined in section 9.5.1 are stored
  // in our main structure, and not replicated here.

  // Port number is stored in the main structure, and not replicated here.
  unsigned int dot1xSuppEapolFramesRx;
  unsigned int dot1xSuppEapolFramesTx;
  unsigned int dot1xSuppEapolStartFramesTx;
  unsigned int dot1xSuppEapolLogoffFramesTx;
  unsigned int dot1xSuppEapolRespIdFramesTx;
  unsigned int dot1xSuppEapolRespFramesTx;
  unsigned int dot1xSuppEapolReqIdFramesRx;
  unsigned int dot1xSuppEapolReqFramesRx;
  unsigned int dot1xSuppInvalidEapolFramesRx;
  unsigned int dot1xSuppEapLengthErrorFramesRx;
  unsigned char dot1xSuppLastEapolFrameVersion;
  unsigned char dot1xSuppLastEapolFrameSource[6];

  // These are not defined in the 802.1X-2001 document, but may be interesting
  // anyway.
  unsigned int eapol_success_rx;
  unsigned int eapol_fail_rx;
};


void snmp_dump_stats(struct interface_data *);

#endif
