/***************************************************************************
 *   Copyright (C) 2005 by Paulo Ferreira                                  *
 *   acfpaulo@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qfile.h>
#include <qtextstream.h>
#include <stdlib.h>

#include "configobject.h"

#include "xsupplicant.h"

//-----------------------------------------------------------------------------------------------------------
//---------------- Constructors (Construct This Object) -----------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
Xsupplicant::Xsupplicant(const QString &interface):
interface(interface)
{    
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Destructor is Empty ----------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
Xsupplicant::~Xsupplicant()
{
}

//-----------------------------------------------------------------------------------------------------------
//---------------- To Start the Xsupplicant Program ---------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
bool Xsupplicant::startXsupplicant()
{
    if (isXsupplicant())
    {        
        system("echo \"[Open1xSupplicant]  ERROR in startXsupplicant initialization\" >> /var/log/xsupplicant.log");
        return FALSE;
    }
    else
    {
        QString command( "xsupplicant -c " );
        command += getenv("HOME");
        command += "/.open1xsupplicant/open1xsupplicant.conf -i ";
        command += interface;
        command += " &";

        if ( system(command) == -1)
        {                    
            system("echo \"[Open1xSupplicant]  ERROR in startXsupplicant initialization\" >> /var/log/xsupplicant.log");
            return FALSE;
        }
        else
            system("echo \"[Open1xSupplicant]  startXsupplicant initialization OK\" >> /var/log/xsupplicant.log");
        return TRUE;
    }   
}

//-----------------------------------------------------------------------------------------------------------
//---------------- To Stop Xsupplicant if it running --------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
bool Xsupplicant::stopXsupplicant()
{                  
    if ( isXsupplicant() )
    {
        QFile log_file( "/var/run/xsupplicant" );
        if ( log_file.exists() )     
            if ( system("rm /var/run/xsupplicant") == -1 )
                return FALSE;
            else
                if ( log_file.exists() )
                    return FALSE; 

        QString dir(getenv("HOME"));
        dir += "/.open1xsupplicant/pids";
        QFile file( dir );
        if ( file.open( IO_ReadOnly ) )
        { 
            QTextStream stream( &file );
            stream.setEncoding(QTextStream::UnicodeUTF8);
            
            while ( !stream.atEnd() ) 
            {                
                    QString aux("kill ");
                    aux += stream.readLine(); 
                    system(aux);                   
            }    
          file.close();
          return TRUE;
         }
         else 
            return FALSE;
    }
    else
        return FALSE;  
}

//-----------------------------------------------------------------------------------------------------------
//---------------- If Xsupplicant is running ----------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
bool Xsupplicant::isXsupplicant()
{
    QFile log_file( "/var/run/xsupplicant" );    

    QString dir(getenv("HOME"));
    dir += "/.open1xsupplicant/pids";
    QString command("ps aux | tr -s \" \" \":\" | cut -f2,13,14 -d\":\" | grep \"xsupplicant:-c\" | cut -f1 -d\":\" > ");
    command += dir;    
    
    if ( system(command) != -1 )
    {        
        QFile file( dir );
        if ( file.size() > 0 || log_file.exists() )
            return TRUE;
    }
    return FALSE;
}

//-----------------------------------------------------------------------------------------------------------
//---------------- To Verify if DHCP Deamon is Working in the Xsupplicant Interface -------------------------
//-----------------------------------------------------------------------------------------------------------
bool Xsupplicant::isDHCP(uint dhcptype)
{
    QString dir(getenv("HOME"));
    dir += "/.open1xsupplicant/pids";
    QString command;
    
    switch(dhcptype)
    {
        case DHCPCD:
        {
            command += "ps aux | tr -s \" \" \":\" | cut -f2,13,16 -d\":\" | grep \"dhcpcd:";
            command += interface;
            command += "\" | cut -f1 -d\":\" > ";
            command += dir;            
            break;
        }
        case DHCLIENT:
        {
            command += "ps aux | tr -s \" \" \":\" | cut -f2,13,14 -d\":\" | grep \"dhclient:";
            command += interface;
            command += "\" | cut -f1 -d\":\" > ";
            command += dir;            
            break; 
        }
    }
    
    if ( system( command ) != -1 )
    {        
        QFile file( dir );
        if ( file.size() > 0 )
            return TRUE;        
    } 
    return FALSE;  
}

//-----------------------------------------------------------------------------------------------------------
//---------------- This Function is Used to Clean DHCP Deamon, to Xsupplicant Work Well ---------------------
//-----------------------------------------------------------------------------------------------------------
bool Xsupplicant::stopDHCP( uint dhcptype )
{       
    if ( isDHCP( dhcptype ) )
    {
    
        QString dir(getenv("HOME"));
        dir += "/.open1xsupplicant/pids";
        QFile file( dir );
        if ( file.open( IO_ReadOnly ) )
        { 
            QTextStream stream( &file );
            stream.setEncoding(QTextStream::UnicodeUTF8);
            
            while ( !stream.atEnd() ) 
            {                
                    QString aux("kill ");
                    aux += stream.readLine(); 
                    system(aux);                   
            }    
          file.close();
          return TRUE;
         }
         else 
            return FALSE;
    }
    else
        return FALSE;
}


//-----------------------------------------------------------------------------------------------------------
//---------------- To Initialize the Network Parameters -----------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
bool Xsupplicant::initNetwork(const QString &ssid, uint type_key)
{
    QString command( "ifconfig " );
    command += interface;
    command += " down ";
    if ( system(command) == -1 )
        return FALSE;
    
    command = "iwconfig ";
    command += interface;
    command += " essid ";
    command += ssid;
    command += " key ";
    switch(type_key)
    {
        case 40:
        {
            command += "s:12345";
            break;
        }
        case 128:
        {
            command += "s:1234567890qwe";
            break;
        }
        default:
        {
            command += "s:12345";
            break;
        }
    }
    command += " enc open";
    
    if ( system(command) == -1 )
        return FALSE;
    
    QString command2 = "ifconfig ";
    command2 += interface;
    command2 += " allmulti up ";
    if ( system(command2) == -1 )
        return FALSE;
    if ( system(command) == -1 )
        return FALSE;
    else
        return TRUE;
}

//-----------------------------------------------------------------------------------------------------------
//---------------- To write to File the Wireless Connection Status ------------------------------------------
//-----------------------------------------------------------------------------------------------------------
bool Xsupplicant::showNetworkParam()
{
    QString dir("/var/log/xsupplicant.log");
    QFile file( dir );
    if ( file.open( IO_ReadOnly ) )
    { 
        QTextStream stream( &file );
        stream.setEncoding(QTextStream::UnicodeUTF8);
        while ( !stream.atEnd() )
        {                  
            QString info( stream.readLine() ); 
            if ( info.contains("Authenticated!",FALSE) > 0 )
            {                                  
                dir = getenv("HOME");
                dir += "/.open1xsupplicant/status";
                QFile status( dir );
                if ( !status.open( IO_WriteOnly ) )
                {
                    file.close();
                    return FALSE;
                }
                QTextStream stream_status( &status );
                stream_status.setEncoding(QTextStream::UnicodeUTF8);
                stream_status << info;
                status.close(); 
                return TRUE;
            }
        }
        file.close();  
    }   
    return FALSE;     

    //return TRUE;
}

//-----------------------------------------------------------------------------------------------------------
//---------------- To Modify the Attribute interface to use it in Xsupplicant Start Procedure ---------------
//-----------------------------------------------------------------------------------------------------------
void Xsupplicant::setInterface(const QString &interface)
{
    Xsupplicant::interface = interface;
}

//-----------------------------------------------------------------------------------------------------------
//---------------- To Get the Value of Interface Attribute --------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
QString Xsupplicant::getInterface()
{
    return interface;
}


