/***************************************************************************
 *   Copyright (C) 2005 by Paulo Ferreira                                  *
 *   acfpaulo@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _OPEN1XSUPPLICANT_H_
#define _OPEN1XSUPPLICANT_H_

#include <qmainwindow.h>
#include <qstring.h>
#include <qtoolbar.h>

#include "filemanager.h"
#include "languages.h"

class QToolBar;
class QPopupMenu;
class ABCentralWidget;

/**
 * @short Application Main Window
 * @author Paulo Ferreira <acfpaulo@gmail.com>
 * @version 0.1
 */
class Open1xSupplicant : public QMainWindow
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    	Open1xSupplicant();

    /**
     * Default Destructor
     */
    	virtual ~Open1xSupplicant();
    
protected slots:   
	void fileNew();
	void fileSave();
	void fileSaveAs();
	void refreshInterfaces();
	void refreshNetSSIDs();
	void stopDHCP();
	void stopXsupplicant();
	void ShowLogFile();
	void showCredits();
	void showAbout();
	void showHelp();

protected:
	void setupMenuBar();
	void setupFileTools();
	void setupStatusBar();
	void setupCentralWidget();

	QToolBar *fileTools;
	QString filename;
	FileManager *body;
	Languages *lang;

};

#endif // _OPEN1XSUPPLICANT_H_
