/***************************************************************************
 *   Copyright (C) 2005 by Paulo Ferreira                                  *
 *   acfpaulo@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qapplication.h>
#include <stdlib.h>

#include "open1xsupplicant.h"

int main( int argc, char ** argv )
{
    QApplication a( argc, argv );
    QString path_icon( getenv("HOME") );
    path_icon += "/.open1xsupplicant/open1xsupplicant.png"; 
    QPixmap icon(path_icon);    
    Open1xSupplicant *window = new Open1xSupplicant();
    window->setCaption( "Open1xSupplicant 0.1" );
    a.setMainWidget( window );
    window->setIcon(icon);
    window->show();

    a.connect( &a, SIGNAL( lastWindowClosed() ), &a, SLOT( quit() ) );
    int result = a.exec();
    delete window;
    return result;
}
