/***************************************************************************
 *   Copyright (C) 2005 by Paulo Ferreira                                  *
 *   acfpaulo@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CONFIGOBJECT_H
#define CONFIGOBJECT_H

#include <qstring.h>

//----DeFine Methods------
#define PEAP 0
#define TTLS 1
#define MSCHAPV2 2
//------------------------
//----Define WEP Sizes----
#define WEP1 40
#define WEP2 128
//------------------------
//----Define DHCP Clients-
#define DHCPCD 0
#define DHCLIENT 1
//------------------------


/**
@author Paulo Ferreira
*/
class ConfigObject{
private:
	QString interface;
	uint method;
	uint submethod;
	QString ssid;
	QString login;
	QString pass;
	uint wep;
	bool dhcp;
	uint dhcptype;

public:
	ConfigObject();
	ConfigObject(const QString &interface, uint method, uint submethod, const QString &ssid, const QString &login, const QString &pass, uint wep, bool dhcp, uint dhcptype);
    
	~ConfigObject();

	QString getInterface();
	uint getMethod();
	uint getSubMethod();
	QString getSSID();
	QString getLogin();
	QString getPassword();
	uint getWep();
	bool getDHCP();
	uint getDHCPType();
	
	bool hasInterface();	
	bool hasSSID();
	bool hasLogin();
	bool hasPassword();
	
	void setConfigObject(const QString &interface, uint method, uint submethod, const QString &ssid, const QString &login, const QString &pass, uint wep, bool dhcp, uint dhcptype);
	void setInterface(const QString &interface);
	void setMethod(uint method);
	void setSubMethod(uint submethod);
	void setSSID(const QString &ssid);
	void setLogin(const QString &login);
	void setPassword(const QString &pass);
	void setWep(uint wep);
	void setDHCP(bool dhcp);
	void setDHCPType(uint dhcptype);
};

#endif
