/***************************************************************************
 *   Copyright (C) 2005 by Paulo Ferreira                                  *
 *   acfpaulo@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "open1xsupplicant.h"

#include <qapplication.h>
#include <qfiledialog.h>
#include <qmenubar.h>
#include <qmessagebox.h>
#include <qpopupmenu.h>
#include <stdlib.h>

#include "logfile.h"

//-----------------------------------------------------------------------------------------------------------
//---------------- Constructors (Construct This Object) -----------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
Open1xSupplicant::Open1xSupplicant()
    : QMainWindow( 0, "Open1xSupplicant 0.1" ),
      filename( )
{
    lang = new Languages( );
    setupMenuBar();    
    setupCentralWidget();
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Destructor is Empty ----------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
Open1xSupplicant::~Open1xSupplicant()
{
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Create the Menu Bar ----------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
void Open1xSupplicant::setupMenuBar()
{
    QPopupMenu *file = new QPopupMenu( this );
    menuBar()->insertItem( lang->showMessage( MENUS, 0 ), file );

    file->insertItem( lang->showMessage( MENUS_ITEMS, 0 ), this, SLOT( fileNew() ), CTRL + Key_L );    
    file->insertSeparator();
    file->insertItem( QPixmap( "filesave.xpm" ), lang->showMessage( MENUS_ITEMS, 1 ), this, SLOT( fileSave() ), CTRL + Key_G );
    //file->insertItem( lang->showMessage( MENUS_ITEMS, 2 ), this, SLOT( fileSaveAs()), CTRL + Key_C);   
    file->insertSeparator();       
    file->insertItem( lang->showMessage( MENUS_ITEMS, 2 ), qApp, SLOT( quit() ), CTRL + Key_F );
    
    QPopupMenu *confs = new QPopupMenu( this );
    menuBar()->insertItem( lang->showMessage( MENUS, 1 ), confs );

    confs->insertItem( lang->showMessage( MENUS_ITEMS, 3 ), this, SLOT( refreshInterfaces() ), CTRL + Key_A );   
    confs->insertItem( lang->showMessage( MENUS_ITEMS, 4 ), this, SLOT( refreshNetSSIDs() ), CTRL + Key_R ); 
    confs->insertSeparator();   
    confs->insertItem( lang->showMessage( MENUS_ITEMS, 5 ), this, SLOT( stopDHCP() ), CTRL + Key_D);
    confs->insertItem( lang->showMessage( MENUS_ITEMS, 6 ), this, SLOT( stopXsupplicant() ), CTRL + Key_X); 
    confs->insertSeparator(); 
    confs->insertItem( lang->showMessage( MENUS_ITEMS, 7 ), this, SLOT( ShowLogFile() ), CTRL + Key_C);
    
    QPopupMenu *help = new QPopupMenu( this );
    menuBar()->insertItem( lang->showMessage( MENUS, 2 ), help );
    
    help->insertItem( lang->showMessage( MENUS_ITEMS, 8 ), this, SLOT( showHelp() ), CTRL + Key_O ); 
    help->insertSeparator();
    help->insertItem( lang->showMessage( MENUS_ITEMS, 9 ), this, SLOT( showCredits() ), CTRL + Key_E );
    help->insertSeparator();
    help->insertItem( lang->showMessage( MENUS_ITEMS, 10 ), this, SLOT( showAbout() ), CTRL + Key_S ); 
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Put the Body in Main Window --------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
void Open1xSupplicant::setupCentralWidget()
{
    body = new FileManager( *lang, this );
    setCentralWidget( body );
    QString aux(body->getDir());
    aux += "open1xsupplicant.conf";
    filename = aux;
}

void Open1xSupplicant::fileNew()
{
    body->cleanFields();
}

void Open1xSupplicant::fileSave()
{
    /*if ( filename.isEmpty() ) {
        fileSaveAs();
        return;
    }*/

    body->saveFile( filename );
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Save As the Conf File --------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
void Open1xSupplicant::fileSaveAs()
{
    QString fn = QFileDialog::getSaveFileName( QString::null, QString::null, this );
    if ( !fn.isEmpty() ) {
        filename = fn;
        fileSave();
    }
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Verify Changes in The System Interfaces --------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
void Open1xSupplicant::refreshInterfaces()
{
    body->getInterfaces();
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Verify Changes in The Networks SSIDs -----------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
void Open1xSupplicant::refreshNetSSIDs()
{
    body->getNetworksSSID();
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Stop DHCP Deamon if it Working in xsupplicant Interface ----------------------------------
//-----------------------------------------------------------------------------------------------------------
void Open1xSupplicant::stopDHCP()
{
    body->stopDHCP();
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Stop Xsupplicant Deamon if it Working ----------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
void Open1xSupplicant::stopXsupplicant()
{
    body->stopXsupplicant();
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Show Xsupplicant Log File ----------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
void Open1xSupplicant::ShowLogFile()
{
    ( new LogFile() )->show();
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Show credits of Open1xSsupplicant --------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
void Open1xSupplicant::showCredits()
{            
    QMessageBox::about( this, lang->showMessage( CREDITS_NAME ), lang->showMessage( CREDITS ) );
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Show About of Open1xSsupplicant Qt Objects -----------------------------------------------
//-----------------------------------------------------------------------------------------------------------
void Open1xSupplicant::showAbout()
{    
    QMessageBox::aboutQt( this, "About" );
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Show About of Open1xSsupplicant Qt Objects -----------------------------------------------
//-----------------------------------------------------------------------------------------------------------
void Open1xSupplicant::showHelp()
{
    QString language("Portuguese");
    if ( QString::compare( lang->showLanguage( ).lower(), language.lower() ) == 0)
    {
        if ( system("konqueror http://alumni.ipt.pt/~caceres/open1xsupplicant/index.php?lang=PT &") == -1 )
            body->showMessage( "Konqueror ERROR", WARNING);
    }
    else
    {
        if ( system("konqueror http://alumni.ipt.pt/~caceres/open1xsupplicant/index.php?lang=EN &") == -1 )
            body->showMessage( "Konqueror ERROR", WARNING);
     }
}
