/***************************************************************************
 *   Copyright (C) 2005 by Paulo Ferreira                                  *
 *   acfpaulo@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "logfile.h"

#include <qfile.h>
#include <stdlib.h>

//-----------------------------------------------------------------------------------------------------------
//---------------- Constructor (Construct This Object) ------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
LogFile::LogFile():
QMainWindow( 0, "Open1xSupplicant 0.1" )
{    
    setupLogFile();
    
    LoadLogFile( "/var/log/xsupplicant.log" );
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Destructor is Empty ----------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
LogFile::~LogFile()
{
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Draw the Status Bar Above ----------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
void LogFile::setupLogFile()
{                        
    log_file = new QListBox( this );    
    setCentralWidget( log_file );        
    log_file->insertItem( "------->XSUPPLICANT LOG FILE<-------" );
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Load Xsupplicant Log File ----------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
void LogFile::LoadLogFile( QString filename )
{
    QFile file( filename );
         
    if ( !file.open( IO_ReadOnly ) )    
        return;

    QTextStream stream( &file );
    stream.setEncoding(QTextStream::UnicodeUTF8);
    
    while ( !stream.atEnd() ) 
    {
        QString line =  stream.readLine();
        log_file->insertItem( line );       
    }    
    
    file.close();
}

