/***************************************************************************
 *   Copyright (C) 2005 by Paulo Ferreira                                  *
 *   acfpaulo@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef LANGUAGES_H
#define LANGUAGES_H

#include <qfile.h>

//---Define Types of XML Part---
#define CREDITS_NAME 0
#define CREDITS 1
#define MENUS 2
#define MENUS_ITEMS 3
#define LABELS 4
#define TABS 5
#define INFORMATIONS_CAB 6
#define INFORMATIONS 7
#define BUTTONS 8
#define DHCP 9
#define MESSAGES 10
//------------------------------

/**
@author Paulo Ferreira
*/
class Languages
{
public:
	Languages();
	Languages( Languages &lang );
	~Languages();
	
	bool creatDefaultLang();
	QString showMessage( uint type, uint index = 0 );
	QString showLanguage();

protected:	
	QString showMenus( uint type, uint index = 0 );
	QString showTabs( uint index );
	QString showLabels( uint index );
	QString showButtons( uint index );
	QString showDHCP( uint index );
	QString showMessages( uint index );
	QString showInfo( uint type, uint index = 0 );
	QString showCredits( uint type );
	
	QFile *file;

};

#endif
