/***************************************************************************
 *   Copyright (C) 2005 by Paulo Ferreira                                  *
 *   acfpaulo@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "languages.h"

#include <qdir.h>
#include <qstring.h>
#include <qtextstream.h>
#include <stdlib.h>

//-----------------------------------------------------------------------------------------------------------
//---------------- Constructor (Construct This Object) ------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
Languages::Languages()
{
    QString dir( getenv("HOME") );
    dir += "/.open1xsupplicant/";            
    
    QDir directory(dir);
    if (!directory.exists())
    {        
        QDir directory_aux;
        directory_aux.mkdir( dir, TRUE );      
    }
    dir += "language.xml";
    file = new QFile(dir);
    if ( !file->exists() )
        creatDefaultLang();
    
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Copy Constructor (Construct This Object) -------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
Languages::Languages( Languages &lang )
{
    file = lang.file;
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Destructor is Empty ----------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
Languages::~Languages()
{
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Create The Default Language File ---------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
bool Languages::creatDefaultLang()
{
    if ( !file->open( IO_WriteOnly ) )
        return FALSE;

    QTextStream stream( file );
    stream.setEncoding(QTextStream::UnicodeUTF8);
        
    stream << "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    stream << "<DOCUMENT>\n";
    
    stream << "  <LANGUAGE>English</LANGUAGE>\n";
    
    stream << "  <POPUPMENUS>\n";
    stream << "    <MENU>File\n";
    stream << "      <ITEM>Reset Fields</ITEM>\n";
    stream << "      <ITEM>Save</ITEM>\n";    
    stream << "      <ITEM>Close</ITEM>\n";
    stream << "    </MENU>\n";
    stream << "    <MENU>Configure\n";
    stream << "      <ITEM>Refresh Interfaces</ITEM>\n";
    stream << "      <ITEM>Refresh Networks SSIDs</ITEM>\n";
    stream << "      <ITEM>Stop DHCP</ITEM>\n";
    stream << "      <ITEM>Stop Authentication</ITEM>\n";
    stream << "      <ITEM>Show Xsupplicant Log File</ITEM>\n";
    stream << "    </MENU>\n";
    stream << "    <MENU>Help\n";
    stream << "      <ITEM>OnLine Help</ITEM>\n";
    stream << "      <ITEM>Developers</ITEM>\n";
    stream << "      <ITEM>About</ITEM>\n";
    stream << "    </MENU>\n";
    stream << "  </POPUPMENUS>\n";
    
    stream << "  <TABS>\n";
    stream << "    <TAB>User Data</TAB>\n";
    stream << "    <TAB>Configuration</TAB>\n";    
    stream << "  </TABS>\n";   
    
    stream << "  <LABELS>\n";
    stream << "    <LABEL>User</LABEL>\n";
    stream << "    <LABEL>Password</LABEL>\n";
    stream << "    <LABEL>Interface</LABEL>\n";
    stream << "    <LABEL>Method</LABEL>\n";
    stream << "    <LABEL>SSID</LABEL>\n";
    stream << "    <LABEL>SSID List</LABEL>\n";
    stream << "    <LABEL>WEP</LABEL>\n";
    stream << "    <LABEL>DHCP</LABEL>\n";
    stream << "    <LABEL>Client</LABEL>\n";
    stream << "  </LABELS>\n";
    
    stream << "  <BUTTONS>\n";
    stream << "    <BUTTON>Submit</BUTTON>\n";
    stream << "    <BUTTON>Change</BUTTON>\n";
    stream << "  </BUTTONS>\n";
    
    stream << "  <DHCP>\n";
    stream << "    <TRUE>WITH</TRUE>\n";
    stream << "    <FALSE>WITHOUT</FALSE>\n";
    stream << "  </DHCP>\n";
    
    stream << "  <INFORMATIONS>\n";
    stream << "    <CAB>INFORMATION</CAB>\n";    
    stream << "    <MESSAGE>DHCP shutdown on interface #INTF#. You may start the Authentication process.</MESSAGE>\n";
    stream << "    <MESSAGE>The Authentication process has been stopped.</MESSAGE>\n";    
    stream << "    <MESSAGE>The interface #INTF# has active DHCP. You have to stop it before the Authentication process.</MESSAGE>\n";
    stream << "    <MESSAGE>The interface #INTF# does not have active DHCP. You may start Authentication process.</MESSAGE>\n";
    stream << "    <MESSAGE>The Authentication process is running. You have to stop it.</MESSAGE>\n";
    stream << "    <MESSAGE>There is no Authentication process running.</MESSAGE>\n";        
    stream << "    <MESSAGE>#INTF# is</MESSAGE>\n";
    stream << "    <MESSAGE>#INTF# is not Authenticated.</MESSAGE>\n";            
    stream << "  </INFORMATIONS>\n";
    
    stream << "  <MESSAGES>\n";
    stream << "    <MESSAGE>Unable to create folder in your home directory.</MESSAGE>\n";
    stream << "    <MESSAGE>There are no wireless devices on this system.</MESSAGE>\n";  
    stream << "    <MESSAGE>There are no SSIDs available.</MESSAGE>\n";
    stream << "    <MESSAGE>Unable to stop DHCP on the current interface.#RTRN# Please stop it manually.</MESSAGE>\n";
    stream << "    <MESSAGE>Unable to start the Authentication process.</MESSAGE>\n";
    stream << "    <MESSAGE>Authentication has been started sucessfully.</MESSAGE>\n";
    stream << "    <MESSAGE>Unable to start wireless devices.</MESSAGE>\n";
    stream << "    <MESSAGE>DHCP is active on the selected interface or there is an Authentication process running.#RTRN# Please stop them first.</MESSAGE>\n";
    stream << "    <MESSAGE>Unable to stop the Authentication processe.#RTRN# Please stop it manually.</MESSAGE>\n";
    stream << "  </MESSAGES>\n";        
    
    stream << "  <CREDITS>\n";
    stream << "    <NAME>Developers</NAME>\n";
    stream << "    <LINE>Software developed by:#RTRN#</LINE>\n";
    stream << "    <LINE>Paulo Ferreira (acfpaulo@gmail.com)</LINE>\n";
    stream << "    <LINE>Bruno Tome (tome.bruno@gmail.com)#RTRN#</LINE>\n";
    stream << "    <LINE>As Graduation Project on</LINE>\n";
    stream << "    <LINE>Computer Engeneering#RTRN#</LINE>\n";
    stream << "    <LINE>Departament of Computer Engeneering</LINE>\n";
    stream << "    <LINE>Technology Superior School of Tomar</LINE>\n";
    stream << "    <LINE>Polytechnic Institute of Tomar</LINE>\n";
    stream << "    <LINE>Portugal</LINE>\n";
    stream << "  </CREDITS>\n";
    
    stream << "</DOCUMENT>\n";
    
    file->close();
    
    return TRUE;
}

//-----------------------------------------------------------------------------------------------------------
//---------------- General Parser to Language File ----------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
QString Languages::showMessage( uint type, uint index )
{
    switch(type)
    {
        case CREDITS_NAME:
        {     
            return showCredits( type );       
        }
        case CREDITS:
        {
            return showCredits( type );
        }
        case MENUS:
        {
            return showMenus( type, index );
        }
        case MENUS_ITEMS:
        {
            return showMenus( type, index );
        }
        case LABELS:
        {
            return showLabels( index );
        }
        case TABS:
        {
            return showTabs( index );
        }
        case INFORMATIONS_CAB:
        {
            return showInfo( type );
        }
        case INFORMATIONS:
        {
            return showInfo( type, index );
        }
        case BUTTONS:
        {
            return showButtons( index );
        }
        case DHCP:
        {
            return showDHCP( index );
        }
        case MESSAGES:
        {
            return showMessages( index );
        }
    }
    return "ERROR IN TYPE OF MESSAGE";
}

//-----------------------------------------------------------------------------------------------------------
//---------------- PopupMenus Parser to Language File -------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
QString Languages::showMenus( uint type, uint index )
{
    if ( !file->open( IO_ReadOnly ) )   
        return "ERROR IN LANGUAGES FILE";

    QString result;
    bool isPopupMenu = FALSE;
    uint count = 0;
    
    QTextStream stream( file );
    stream.setEncoding( QTextStream::UnicodeUTF8 );
    
    while ( !stream.atEnd() ) 
    {
        QString line =  stream.readLine();
        if ( line.contains( "<POPUPMENUS>",FALSE ) > 0 )
            isPopupMenu = TRUE;
        if ( line.contains( "</POPUPMENUS>",FALSE ) > 0 )
            isPopupMenu = FALSE;

        if ( isPopupMenu && line.contains( "<MENU>",FALSE ) > 0 && type == MENUS )      
            if ( count == index )     
            {
                result = "&";
                result += line.remove( "<MENU>" ).simplifyWhiteSpace();
                file->close();
                return result;
            }
            else
                count++;          

        if ( isPopupMenu && line.contains( "<ITEM>",FALSE ) > 0 && type == MENUS_ITEMS )        
            if ( count == index )
            {
                result = line.remove( "<ITEM>" ).simplifyWhiteSpace();                
                file->close();
                return result.remove( "</ITEM>" ).simplifyWhiteSpace();
            }
            else
                count++;
    }                        
    file->close();
    
    return result;
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Tabs Parser to Language File -------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
QString Languages::showTabs( uint index )
{
    if ( !file->open( IO_ReadOnly ) )   
        return "ERROR IN LANGUAGES FILE";

    QString result;
    bool isLabels = FALSE;
    uint count = 0;
    
    QTextStream stream( file );
    stream.setEncoding( QTextStream::UnicodeUTF8 );
    
    while ( !stream.atEnd() ) 
    {
        QString line =  stream.readLine();
        if ( line.contains( "<TABS>",FALSE ) > 0 )
            isLabels = TRUE;
        if ( line.contains( "</TABS>",FALSE ) > 0 )
            isLabels = FALSE;                  

        if ( isLabels && line.contains( "<TAB>",FALSE ) > 0 )        
            if ( count == index )
            {
                QString aux = line.remove( "<TAB>" ).simplifyWhiteSpace();
                result ="&";
                result += aux.remove( "</TAB>" ).simplifyWhiteSpace();
                file->close();
                return result;
            }
            else
                count++;
    }                        
    file->close();
    
    return result;
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Labels Parser to Language File -----------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
QString Languages::showLabels( uint index )
{
    if ( !file->open( IO_ReadOnly ) )   
        return "ERROR IN LANGUAGES FILE";

    QString result;
    bool isLabels = FALSE;
    uint count = 0;
    
    QTextStream stream( file );
    stream.setEncoding( QTextStream::UnicodeUTF8 );
    
    while ( !stream.atEnd() ) 
    {
        QString line =  stream.readLine();
        if ( line.contains( "<LABELS>",FALSE ) > 0 )
            isLabels = TRUE;
        if ( line.contains( "</LABELS>",FALSE ) > 0 )
            isLabels = FALSE;                  

        if ( isLabels && line.contains( "<LABEL>",FALSE ) > 0 )        
            if ( count == index )
            {
                result = line.remove( "<LABEL>" ).simplifyWhiteSpace();                
                file->close();
                return result.remove( "</LABEL>" ).simplifyWhiteSpace();;
            }
            else
                count++;
    }                        
    file->close();
    
    return result;
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Buttons Parser to Language File ----------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
QString Languages::showButtons( uint index )
{
    if ( !file->open( IO_ReadOnly ) )   
        return "ERROR IN LANGUAGES FILE";

    QString result;
    bool isButtons = FALSE;
    uint count = 0;
    
    QTextStream stream( file );
    stream.setEncoding( QTextStream::UnicodeUTF8 );
    
    while ( !stream.atEnd() ) 
    {
        QString line =  stream.readLine();
        if ( line.contains( "<BUTTONS>",FALSE ) > 0 )
            isButtons = TRUE;
        if ( line.contains( "</BUTTONS>",FALSE ) > 0 )
            isButtons = FALSE;                  

        if ( isButtons && line.contains( "<BUTTON>",FALSE ) > 0 )        
            if ( count == index )
            {
                QString aux = line.remove( "<BUTTON>" ).simplifyWhiteSpace();
                result ="&";
                result += aux.remove( "</BUTTON>" ).simplifyWhiteSpace();
                file->close();
                return result;
            }
            else
                count++;
    }                        
    file->close();
    
    return result;
}

//-----------------------------------------------------------------------------------------------------------
//---------------- DHCP Existence Parser to Language File ---------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
QString Languages::showDHCP( uint index )
{
    if ( !file->open( IO_ReadOnly ) )   
        return "ERROR IN LANGUAGES FILE";

    QString result;
    bool isDHCP = FALSE;   
    
    QTextStream stream( file );
    stream.setEncoding( QTextStream::UnicodeUTF8 );
    
    while ( !stream.atEnd() ) 
    {
        QString line =  stream.readLine();
        if ( line.contains( "<DHCP>",FALSE ) > 0 )
            isDHCP = TRUE;
        if ( line.contains( "</DHCP>",FALSE ) > 0 )
            isDHCP = FALSE;                  

        if ( isDHCP && index == 0 && line.contains( "<TRUE>",FALSE ) > 0 )
        {
            result = line.remove( "<TRUE>" ).simplifyWhiteSpace();                                
            file->close();
            return result.remove( "</TRUE>" ).simplifyWhiteSpace();
        }  
        if ( isDHCP && index == 1 && line.contains( "<FALSE>",FALSE ) > 0 )                  
        {
            result = line.remove( "<FALSE>" ).simplifyWhiteSpace();                                
            file->close();
            return result.remove( "</FALSE>" ).simplifyWhiteSpace();
        }             
    }                        
    file->close();
    
    return result;
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Messages Parser to Language File ---------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
QString Languages::showMessages( uint index )
{
    if ( !file->open( IO_ReadOnly ) )   
        return "ERROR IN LANGUAGES FILE";

    QString result;
    bool isMessage = FALSE;
    uint count = 0;
    
    QTextStream stream( file );
    stream.setEncoding( QTextStream::UnicodeUTF8 );
    
    while ( !stream.atEnd() ) 
    {
        QString line =  stream.readLine();
        if ( line.contains( "<MESSAGES>",FALSE ) > 0 )
            isMessage = TRUE;
        if ( line.contains( "</MESSAGES>",FALSE ) > 0 )
            isMessage = FALSE;                  

        if ( isMessage && line.contains( "<MESSAGE>",FALSE ) > 0 )        
            if ( count == index )
            {
                QString aux = line.remove( "<MESSAGE>" ).simplifyWhiteSpace();
                result += aux.remove( "</MESSAGE>" ).simplifyWhiteSpace();
                result.replace( "#RTRN#", "\n" );
                file->close();
                return result;
            }
            else
                count++;
    }                        
    file->close();
    
    return result;
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Informations Box Parser to Language File -------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
QString Languages::showInfo( uint type, uint index )
{
    if ( !file->open( IO_ReadOnly ) )   
        return "ERROR IN LANGUAGES FILE";

    QString result;
    bool isInfo = FALSE;
    uint count = 0;
    
    QTextStream stream( file );
    stream.setEncoding( QTextStream::UnicodeUTF8 );
    
    while ( !stream.atEnd() ) 
    {
        QString line =  stream.readLine();
        if ( line.contains( "<INFORMATIONS>",FALSE ) > 0 )
            isInfo = TRUE;
        if ( line.contains( "</INFORMATIONS>",FALSE ) > 0 )
            isInfo = FALSE;                  

        if ( isInfo && line.contains( "<CAB>",FALSE ) > 0 && type == INFORMATIONS_CAB)        
            if ( count == index )
            {
                QString aux = line.remove( "<CAB>" ).simplifyWhiteSpace();
                result = "---> ";
                result += aux.remove( "</CAB>" ).simplifyWhiteSpace();
                result += " <---";
                file->close();
                return result;
            }
            else
                count++;

        if ( isInfo && line.contains( "<MESSAGE>",FALSE ) > 0 && type == INFORMATIONS)        
            if ( count == index )
            {
                result = line.remove( "<MESSAGE>" ).simplifyWhiteSpace();                
                file->close();
                return result.remove( "</MESSAGE>" ).simplifyWhiteSpace();
            }
            else
                count++;       
    }                        
    file->close();
    
    return result;
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Credits Parser to Language File ----------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
QString Languages::showCredits( uint type )
{
    if ( !file->open( IO_ReadOnly ) )   
        return "ERROR IN LANGUAGES FILE";

    QString result;
    bool isCredits = FALSE;
    
    QTextStream stream( file );
    stream.setEncoding( QTextStream::UnicodeUTF8 );
    
    uint count = 0;
    while ( !stream.atEnd() ) 
    {
        QString line =  stream.readLine();
        if ( line.contains( "<CREDITS>",FALSE ) > 0 )
            isCredits = TRUE;
        if ( line.contains( "</CREDITS>",FALSE ) > 0 )
            isCredits = FALSE;

        if ( isCredits && line.contains( "<LINE>",FALSE ) > 0 && type == CREDITS )
        {               
            switch(count)
            {
                case 1:
                {
                    result += "Paulo Ferreira (acfpaulo@gmail.com)\n";
                    break;
                }
                case 2:
                {
                    result += "Bruno Tome (tome.bruno@gmail.com)\n\n";
                    break;
                }
                default:       
                {
                    QString aux = line.remove( "<LINE>" ).simplifyWhiteSpace();
                    result += aux.remove( "</LINE>" ).simplifyWhiteSpace();
                    result.replace( "#RTRN#", "\n" );
                    result += "\n";
                }
            }
            count++;
        }   
        
        if ( isCredits && line.contains( "<NAME>",FALSE ) > 0 && type == CREDITS_NAME )
        {
            QString aux = line.remove( "<NAME>" ).simplifyWhiteSpace();
            result += aux.remove( "</NAME>" ).simplifyWhiteSpace();            
        }      
    }                        
    file->close();
    
    return result;
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Return the Language ----------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
QString Languages::showLanguage( )
{
    if ( !file->open( IO_ReadOnly ) )   
        return "ERROR IN LANGUAGES FILE";

    QString result;    
    
    QTextStream stream( file );
    stream.setEncoding( QTextStream::UnicodeUTF8 );
        
    while ( !stream.atEnd() ) 
    {
        QString line =  stream.readLine();        

        if ( line.contains( "<LANGUAGE>",FALSE ) > 0 )
        {                           
            QString aux = line.remove( "<LANGUAGE>" ).simplifyWhiteSpace();
            result += aux.remove( "</LANGUAGE>" ).simplifyWhiteSpace();
            break;
        }           
    }   
    file->close();
    return result;
}

