/***************************************************************************
 *   Copyright (C) 2005 by Paulo Ferreira                                  *
 *   acfpaulo@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
#ifndef FILEMANAGER_H
#define FILEMANAGER_H

#include <qlayout.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qstring.h>
#include <qtabwidget.h>
#include <qwidget.h>

#include "configobject.h"
#include "xsupplicant.h"
#include "languages.h"

//----Define Messages Types----
#define ERROR 0
#define WARNING 1
#define INFORMATION 2
//-----------------------------

/*class QTabWidget;
class QListView;
class QGridLayout;
class QLineEdit;
class QPushButton;
class QListViewItem;
class QCheckBox;*/

/**
@author Paulo Ferreira
*/
class FileManager : public QWidget
{
	Q_OBJECT

public:
	FileManager( Languages &langs, QWidget *parent, const char *name = 0 );

	~FileManager();
	
	void saveFile( const QString &filename );	
	void cleanFields();
	void getInterfaces();
	void getNetworksSSID();
	QString getDir();
	void stopDHCP();
	void stopXsupplicant();
	void showMessage( const QString &message, uint type );

protected slots:
	void changeRegistry();
	void startXsupplicant();
	void itemSelected( QListViewItem *item );
	void ssidSelected( QListBoxItem *item );
	
	
protected:
        void writeWEPSize( QTextStream &stream );
	void writeDHCPMethod( QTextStream &stream );
	void writePEAPMethod( QTextStream &stream );
	void writeTTLSMethod( QTextStream &stream );
        void loadFile( const QString &filename );
	void setupTabWidget();
	void setupListView();
	void setupInfoWidget();		
	void newRegistry();
	void execParser( QString command );
	void setFields();
	void setList( QListViewItem *item );
	void infoDHCP_Xsupp();
	void getWirelessStatus();
	void setInfo( const QString &message );	
	QString coverPassword();
	bool isValidPwd();
	void createDHCPFile(const QString &interface );
	void createReadmeFile();

	
	QGridLayout *mainGrid;	
	QTabWidget *tabWidget;
	QListView *listView;
	QListBox *infStatus, *infNet;
	QPushButton *submit, *change, *rfsh_int;	
	QLineEdit *uiLogin, *uiPass, *cSSID;
	QComboBox *cInterface, *cMethod, *cWEP, *cDHCPType;
	QCheckBox *cDHCP;
	ConfigObject configData;
	Xsupplicant xsupplicant;
	bool isSubMethod;
	QString dir;
	Languages *lang;	

};

#endif
