/***************************************************************************
 *   Copyright (C) 2005 by Paulo Ferreira                                  *
 *   acfpaulo@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "configobject.h"

//-----------------------------------------------------------------------------------------------------------
//---------------- Constructors (Construct This Object) -----------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
ConfigObject::ConfigObject():
interface(),
method(PEAP),
submethod(MSCHAPV2),
ssid(),
login(),
pass(),
wep(WEP1),
dhcp(TRUE),
dhcptype(DHCPCD)
{
}

ConfigObject::ConfigObject(const QString &interface, uint method, uint submethod, const QString &ssid, const QString &login, const QString &pass, uint wep, bool dhcp, uint dhcptype): 
interface(interface),
method(method),
submethod(submethod),
ssid(ssid),
login(login),
pass(pass),
wep(wep),
dhcp(dhcp),
dhcptype(dhcptype)
{
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Destructor is Empty ----------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
ConfigObject::~ConfigObject()
{
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Selectors (Return the Value of One Specific attribute) -----------------------------------
//-----------------------------------------------------------------------------------------------------------
QString ConfigObject::getInterface()
{
    return interface;
}

uint ConfigObject::getMethod()
{
    return method;
}

uint ConfigObject::getSubMethod()
{
    return submethod;
}

QString ConfigObject::getSSID()
{
    return ssid;
}

QString ConfigObject::getLogin()
{
    return login;
}

QString ConfigObject::getPassword()
{
    return pass;
}

uint ConfigObject::getWep()
{
    return wep;
}

bool ConfigObject::getDHCP()
{
    return dhcp;
}

uint ConfigObject::getDHCPType()
{
    return dhcptype;
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Selectors (Return if the attribute is set) -----------------------------------
//-----------------------------------------------------------------------------------------------------------
bool ConfigObject::hasInterface()
{
    return !interface.isEmpty();
}

bool ConfigObject::hasSSID()
{
    return ssid.isEmpty();
}

bool ConfigObject::hasLogin()
{
    return login.isEmpty();
}

bool ConfigObject::hasPassword()
{
    return pass.isEmpty();
}

//-----------------------------------------------------------------------------------------------------------
//---------------- Modifiers (Modify the Class Attributs) --------------------------------------------------
//-----------------------------------------------------------------------------------------------------------
void ConfigObject::setConfigObject(const QString &interface, uint method, uint submethod, const QString &ssid, const QString &login, const QString &pass, uint wep, bool dhcp, uint dhcptype)
{
    ConfigObject::interface = interface;
    ConfigObject::method = method;
    ConfigObject::submethod = submethod;
    ConfigObject::ssid = ssid;
    ConfigObject::login = login;
    ConfigObject::pass = pass;
    ConfigObject::wep = wep;
    ConfigObject::dhcp = dhcp;
    ConfigObject::dhcptype = dhcptype;
}

void ConfigObject::setInterface(const QString &interface)
{
     ConfigObject::interface = interface;
}

void ConfigObject::setMethod(uint method)
{
    ConfigObject::method = method;
}

void ConfigObject::setSubMethod(uint submethod)
{
    ConfigObject::submethod = submethod;
}

void ConfigObject::setSSID(const QString &ssid)
{
    ConfigObject::ssid = ssid;
}

void ConfigObject::setLogin(const QString &login)
{
    ConfigObject::login = login;
}

void ConfigObject::setPassword(const QString &pass)
{
    ConfigObject::pass = pass;
}

void ConfigObject::setWep(uint wep)
{
    ConfigObject::wep = wep;
}

void ConfigObject::setDHCP(bool dhcp)
{
    ConfigObject::dhcp = dhcp;
}

void ConfigObject::setDHCPType(uint dhcptype)
{
    ConfigObject::dhcptype = dhcptype;
}
